package com.ElyStudio.leGaou.activities;

import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;

import android.content.Intent;
import android.media.MediaPlayer;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;

import com.airbnb.lottie.LottieAnimationView;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.android.material.card.MaterialCardView;
import com.ElyStudio.leGaou.R;
import com.ElyStudio.leGaou.databinding.ActivityQuizScreenBinding;
import com.ElyStudio.leGaou.models.GetQuestions;
import com.ElyStudio.leGaou.models.Question;
import com.ElyStudio.leGaou.utilities.ApiController;
import com.ElyStudio.leGaou.utilities.AppCompat;
import com.ElyStudio.leGaou.utilities.CheckInternetConnection;
import com.ElyStudio.leGaou.utilities.Constants;
import com.ElyStudio.leGaou.utilities.QuizzeSnackBar;
import com.squareup.picasso.Picasso;

import java.util.List;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class QuizScreen extends AppCompat {

    ActivityQuizScreenBinding binding;
    String difficulty = "";
    BottomSheetDialog difficultySelectionBottomSheet,noLivesBottomSheet;
    public static final String TAG = "QUIZ_SCREEN";
    private Question question;
    List<Question> questionList;
    MediaPlayer quizBgMusic,correctAnswerMusic,wrongAnswerMusic;
    CountDownTimer quizTimer;


    int easy,medium,hard;
    int quizId,questionLimit,livesAvailable,time;
    String quizName,quizIcon;
    int adEnabled;
    String nativeAdId,interstitialAdId,rewardedAdId;

    //Quiz Score Data
    int currentIndex = 0;

    int questionAttempted = 0;
    int score = 0;
    int quizColor,quizEntryFee;
    int correctAnswers = 0;
    int wrongAnswers = 0;
    int leavedQuestions = 0;
    float prizePerQuestion;
    int index  = 0;

    long millisSecondLeft;

    private InterstitialAd mInterstitialAd;
    private RewardedAd mRewardedAd;
    private BottomSheetDialog exitBottomSheet,noInternetBottomSheet,errorOccurredBottomSheet;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityQuizScreenBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());



        binding.optionA.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                checkAnswer(binding.optionA);
            }
        });

        binding.optionB.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                checkAnswer(binding.optionB);
            }
        });

        binding.optionC.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                checkAnswer(binding.optionC);
            }
        });

        binding.optionD.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                checkAnswer(binding.optionD);
            }
        });


    }

    @Override
    protected void onStart() {
        super.onStart();
        binding.questionLayout.setVisibility(View.GONE);
        getQuizData();
        getDifficulty();
        initSoundEffects();
    }

    void initSoundEffects(){
        quizBgMusic = MediaPlayer.create(QuizScreen.this,R.raw.quiz_bg_music);
        quizBgMusic.setLooping(true);
        correctAnswerMusic = MediaPlayer.create(QuizScreen.this,R.raw.correct_answer);
        wrongAnswerMusic = MediaPlayer.create(QuizScreen.this,R.raw.wrong_answer);
    }

    void getQuizData(){

        adEnabled = getIntent().getIntExtra(Constants.adEnabled,0);
        nativeAdId = getIntent().getStringExtra(Constants.nativeAdId);
        interstitialAdId = getIntent().getStringExtra(Constants.interstitialAdId);
        rewardedAdId = getIntent().getStringExtra(Constants.rewardedAdId);

        quizId = getIntent().getIntExtra(Constants.quizId,0);
        quizName = getIntent().getStringExtra(Constants.quizName);
        quizIcon = getIntent().getStringExtra(Constants.quizIcon);
        quizEntryFee = getIntent().getIntExtra(Constants.quizEntryFee,0);
        quizColor = getIntent().getIntExtra(Constants.quizColorCode,0);

        easy = getIntent().getIntExtra(Constants.quizDifficultyEasy,0);
        medium = getIntent().getIntExtra(Constants.quizDifficultyMedium,0);
        hard = getIntent().getIntExtra(Constants.quizDifficultyHard,0);

        questionLimit = getIntent().getIntExtra(Constants.quizQuestionLimit,0);
        livesAvailable = getIntent().getIntExtra(Constants.quizLivesAvailable,0);
        time = getIntent().getIntExtra(Constants.quizTimeAvailable,0);
        prizePerQuestion = getIntent().getFloatExtra(Constants.quizPrizePerQuestion,prizePerQuestion);

    }

    //Fetching Quiz Questions
    private void getQuestions(){

        if(quizId == 0 || questionLimit == 0 || livesAvailable == 0)
        {
            quizId = getIntent().getIntExtra(Constants.quizId,0);
            questionLimit = getIntent().getIntExtra(Constants.quizQuestionLimit,0);
            livesAvailable = getIntent().getIntExtra(Constants.quizLivesAvailable,0);
        }
        if(CheckInternetConnection.isInternetConnected(QuizScreen.this))
        {
            Call<GetQuestions> getQuestionsCall = ApiController.getInstance().getApi().getQuestions(quizId, difficulty, questionLimit);

            getQuestionsCall.enqueue(new Callback<GetQuestions>() {
                @Override
                public void onResponse(Call<GetQuestions> call, Response<GetQuestions> response) {
                    if (response.body().getStatusCode() == 0) {
                        binding.questionLayout.setVisibility(View.VISIBLE);
                        questionList = response.body().getQuestions();
                        setQuizData(questionList);
                        loadInterstitialAd(interstitialAdId);
                        loadNativeAd(binding.nativeAdPlaceHolder);
                    }
                    else if (response.body().getStatusCode() == 1)
                    {
                        QuizzeSnackBar.showSnackBar(QuizScreen.this, binding.getRoot(), getResources().getString(R.string.no_question_available), getResources().getColor(R.color.warning));
                    }
                    else
                    {
                        showErrorOccurredBottomSheet();
                    }
                }

                @Override
                public void onFailure(Call<GetQuestions> call, Throwable t) {
                    Log.d(TAG, "getQuestionCallFailure = " + t.getLocalizedMessage());
                    showErrorOccurredBottomSheet();
                }
            });
        }
        else
        {
            showNoInternetBottomSheet();
        }

    }

    //Getting Quiz Difficulty
    private void getDifficulty(){

        if(easy+medium+hard == 0) {
            easy = getIntent().getIntExtra(Constants.quizDifficultyEasy,1);
            medium = getIntent().getIntExtra(Constants.quizDifficultyMedium,0);
            hard = getIntent().getIntExtra(Constants.quizDifficultyHard,0);
        }
        else {
            if(easy+medium+hard >= 2) {
                showDifficultySelectionBottomSheet();
            }
            else {

                if(easy == 1){
                    difficulty = "EASY";
                }
                else if(medium == 1){
                    difficulty = "MEDIUM";
                }
                else {
                    difficulty = "HARD";
                }

            }
        }


    }

    private void showDifficultySelectionBottomSheet(){

        difficultySelectionBottomSheet = new BottomSheetDialog(QuizScreen.this);
        View view = LayoutInflater.from(QuizScreen.this).inflate(R.layout.quiz_level_difficulty_bottom_sheet,findViewById(R.id.difficulty_select_layout),false);
        difficultySelectionBottomSheet.setContentView(view);
        difficultySelectionBottomSheet.setCancelable(false);
        TextView easyButton = view.findViewById(R.id.easyButton);
        TextView mediumButton = view.findViewById(R.id.mediumButton);
        TextView hardButton = view.findViewById(R.id.hardButton);

        if(easy == 0){
            easyButton.setVisibility(View.GONE);
        }
        if(medium == 0){
            mediumButton.setVisibility(View.GONE);
        }
        if(hard == 0){
            hardButton.setVisibility(View.GONE);
        }

        easyButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                selectDifficulty("EASY");
            }
        });

        mediumButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                selectDifficulty("MEDIUM");
            }
        });

        hardButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                selectDifficulty("HARD");
            }
        });

        if(!QuizScreen.this.isFinishing())
        {
            difficultySelectionBottomSheet.show();
        }
    }

    void selectDifficulty(String difficultyLevel){
        difficulty = difficultyLevel;
        difficultySelectionBottomSheet.cancel();
        binding.questionLayout.setVisibility(View.GONE);
        getQuestions();
    }

    private void setQuizData(List<Question> questionList){

        binding.userLives.setText(String.valueOf(livesAvailable));
        binding.userScore.setText(String.valueOf(score));
        index = currentIndex + 1;
        String questionCount = getResources().getString(R.string.question_counter_part_one)+' '+ index +' '+getResources().getString(R.string.question_counter_part_two)+' '+questionLimit;
        binding.questionCount.setText(questionCount);
        question = questionList.get(currentIndex);
        binding.question.setText(question.getQuestion());
        if(!question.getImage().trim().isEmpty())
        {
            binding.questionImage.setVisibility(View.VISIBLE);
            Picasso.get().load(Constants.ADMIN_PANEL_URL+question.getImage()).into(binding.questionImage);
        }
        else
        {
            binding.questionImage.setVisibility(View.GONE);
        }

        if(question.getOptionA().isEmpty())
        {
            binding.optionA.setVisibility(View.GONE);
        }
        else
        {
            binding.optionA.setVisibility(View.VISIBLE);
        }

        if(question.getOptionB().isEmpty())
        {
            binding.optionB.setVisibility(View.GONE);
        }
        else
        {
            binding.optionB.setVisibility(View.VISIBLE);
        }

        if(question.getOptionC().isEmpty())
        {
            binding.optionC.setVisibility(View.GONE);
        }
        else
        {
            binding.optionC.setVisibility(View.VISIBLE);
        }

        if(question.getOptionD().isEmpty())
        {
            binding.optionD.setVisibility(View.GONE);
        }
        else
        {
            binding.optionD.setVisibility(View.VISIBLE);
        }

        binding.optionA.setText(question.getOptionA());
        binding.optionB.setText(question.getOptionB());
        binding.optionC.setText(question.getOptionC());
        binding.optionD.setText(question.getOptionD());

        quizBgMusic.start();
        quizCountDownTimer();

    }

    void checkAnswer(TextView userAnswer){

        ++questionAttempted;

        if(quizTimer != null)
        {
            quizTimer.cancel();
        }
        if(quizBgMusic.isPlaying())
        {
            quizBgMusic.pause();
        }

        binding.optionA.setEnabled(false);
        binding.optionB.setEnabled(false);
        binding.optionC.setEnabled(false);
        binding.optionD.setEnabled(false);

        if(userAnswer.getText().toString().equals(question.getAnswer()))
        {
            correctAnswerMusic.start();
            userAnswer.setBackground(ContextCompat.getDrawable(QuizScreen.this,R.drawable.correct_answer_bg));
            score = score + 5;
            ++correctAnswers;
            binding.userScore.setText(score+"");
        }
        else
        {
            wrongAnswerMusic.start();
            userAnswer.setBackground(ContextCompat.getDrawable(QuizScreen.this,R.drawable.wrong_answer_bg));
            --livesAvailable;
            ++wrongAnswers;
            binding.userLives.setText(livesAvailable+"");
        }

        goToNextQuestion();

    }

    void resetAnswers(){

        binding.optionA.setEnabled(true);
        binding.optionB.setEnabled(true);
        binding.optionC.setEnabled(true);
        binding.optionD.setEnabled(true);

        binding.optionA.setBackground(ContextCompat.getDrawable(QuizScreen.this,R.drawable.option_bg));
        binding.optionB.setBackground(ContextCompat.getDrawable(QuizScreen.this,R.drawable.option_bg));
        binding.optionC.setBackground(ContextCompat.getDrawable(QuizScreen.this,R.drawable.option_bg));
        binding.optionD.setBackground(ContextCompat.getDrawable(QuizScreen.this,R.drawable.option_bg));
    }

    //Starting Quiz Timer
    void quizCountDownTimer(){

        quizTimer = new CountDownTimer(time*1000L,1000) {
            @Override
            public void onTick(long millisUntilFinished) {
                binding.quizTimerProgressBar.setMax(time);
                millisSecondLeft = millisUntilFinished;
                int timeLeft = (int) millisUntilFinished/1000;
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                    binding.quizTimerProgressBar.setProgress(timeLeft,true);
                }
                else
                {
                    binding.quizTimerProgressBar.setProgress(timeLeft);
                }

                if(timeLeft > time * 0.65)
                {
                    binding.quizTimerProgressBar.setIndicatorColor(getResources().getColor(R.color.success));
                }
                else if(timeLeft > time * 0.25)
                {
                    binding.quizTimerProgressBar.setIndicatorColor(getResources().getColor(R.color.warning));
                }
                else
                {
                    binding.quizTimerProgressBar.setIndicatorColor(getResources().getColor(R.color.error));
                }

            }

            @Override
            public void onFinish() {
                --livesAvailable;
                ++leavedQuestions;
                binding.userLives.setText(String.valueOf(livesAvailable));
                goToNextQuestion();
            }
        }.start();


    }

    void goToNextQuestion(){

        //Checking Questions is finished
        if(index < questionLimit) {

            //Checking User Lives
            if (livesAvailable > 0) {

                CountDownTimer countDownTimer = new CountDownTimer(2500, 1000) {
                    @Override
                    public void onTick(long millisUntilFinished) {
                        if (millisUntilFinished / 1000 == 1) {
                            binding.quizAnimation.setSpeed(2);
                            binding.quizAnimation.playAnimation();
                            binding.questionLayout.setVisibility(View.GONE);
                            binding.loader.setVisibility(View.VISIBLE);
                        }

                    }

                    @Override
                    public void onFinish() {
                        ++currentIndex;
                        resetAnswers();
                        binding.questionLayout.setVisibility(View.VISIBLE);
                        binding.loader.setVisibility(View.GONE);
                        setQuizData(questionList);

                    }
                };
                countDownTimer.start();
            }
            else
            {
                showNoLivesBottomSheet();
            }
        }
        else
        {
            showQuizFinishInterstitialAd();
        }


    }

    @Override
    public void onBackPressed() {
        showExitBottomSheet();
    }

    public void showNoLivesBottomSheet(){

        if(quizBgMusic.isPlaying())
        {
            quizBgMusic.stop();
        }

        noLivesBottomSheet = new BottomSheetDialog(QuizScreen.this);

        View view = LayoutInflater.from(QuizScreen.this).inflate(R.layout.no_lives_bottom_sheet,(ConstraintLayout) binding.getRoot().findViewById(R.id.noLivesBottomSheetLayout),false);
        noLivesBottomSheet.setContentView(view);
        noLivesBottomSheet.setCancelable(false);

        MaterialCardView watchAdBtn = view.findViewById(R.id.watchLivesAdBtn);
        Button endQuizBtn = view.findViewById(R.id.endQuizBtn);
        LottieAnimationView progressBar = view.findViewById(R.id.adProgressBarLives);

        watchAdBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(adEnabled == 1)
                {
                    progressBar.setVisibility(View.VISIBLE);
                    watchAdBtn.setVisibility(View.GONE);
                    loadRewardedAd(watchAdBtn,progressBar,rewardedAdId);
                }
                else
                {
                    QuizzeSnackBar.showSnackBar(QuizScreen.this,view,getResources().getString(R.string.no_ads_available),getResources().getColor(R.color.error));
                }
            }
        });

        endQuizBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showEndQuizInterstitialAd();
            }
        });

        if(!QuizScreen.this.isFinishing())
        {
            noLivesBottomSheet.show();
        }

    }

    public void loadNativeAd(FrameLayout frameLayout){

        if(adEnabled == 1) {

            AdLoader.Builder builder = new AdLoader.Builder(QuizScreen.this, nativeAdId);

            builder.forNativeAd(new NativeAd.OnNativeAdLoadedListener() {
                @Override
                public void onNativeAdLoaded(@NonNull NativeAd nativeAd) {

                    NativeAdView nativeAdView = (NativeAdView) getLayoutInflater().inflate(R.layout.small_native_ad_layout, null);

                    populateNativeAd(nativeAd, nativeAdView);
                    frameLayout.removeAllViews();
                    frameLayout.addView(nativeAdView);

                }
            });

            AdLoader adLoader = builder.withAdListener(new AdListener() {
                @Override
                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    super.onAdFailedToLoad(loadAdError);
                    Log.d(TAG, "Failed to load native ad =  " + loadAdError);
                }
            }).build();

            adLoader.loadAd(new AdRequest.Builder().build());

        }

    }

    public void populateNativeAd(NativeAd nativeAd, NativeAdView nativeAdView){

        nativeAdView.setIconView(nativeAdView.findViewById(R.id.adIconSmall));
        nativeAdView.setHeadlineView(nativeAdView.findViewById(R.id.adHeadlineSmall));
        nativeAdView.setCallToActionView(nativeAdView.findViewById(R.id.adCallToActionButtonSmall));
        nativeAdView.setBodyView(nativeAdView.findViewById(R.id.adBodySmall));

        if(nativeAd != null)
        {
            ((TextView) nativeAdView.getHeadlineView()).setText(nativeAd.getHeadline());

            if(nativeAd.getIcon() == null)
            {
                nativeAdView.getIconView().setVisibility(View.INVISIBLE);
            }
            else
            {
                nativeAdView.getIconView().setVisibility(View.VISIBLE);
                ((ImageView) nativeAdView.getIconView()).setImageDrawable(nativeAd.getIcon().getDrawable());
            }

            if(nativeAd.getBody() == null)
            {
                nativeAdView.getBodyView().setVisibility(View.INVISIBLE);
            }
            else
            {
                nativeAdView.getBodyView().setVisibility(View.VISIBLE);
                ((TextView) nativeAdView.getBodyView()).setText(nativeAd.getBody());
            }

            if(nativeAd.getCallToAction() == null)
            {
                nativeAdView.getCallToActionView().setVisibility(View.INVISIBLE);
            }
            else
            {
                nativeAdView.getCallToActionView().setVisibility(View.VISIBLE);
                ((Button) nativeAdView.getCallToActionView()).setText(nativeAd.getCallToAction());
            }

            nativeAdView.setNativeAd(nativeAd);


        }

    }

    public void loadInterstitialAd(String adId){

        if(adEnabled == 1)
        {
            AdRequest adRequest = new AdRequest.Builder().build();

            InterstitialAd.load(QuizScreen.this, adId, adRequest, new InterstitialAdLoadCallback() {
                @Override
                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    super.onAdFailedToLoad(loadAdError);
                    mInterstitialAd = null;
                    Log.d(TAG,"Failed to load interstitial ad");
                }

                @Override
                public void onAdLoaded(@NonNull InterstitialAd interstitialAd) {
                    super.onAdLoaded(interstitialAd);
                    mInterstitialAd = interstitialAd;
                }
            });
        }

    }

    public void showQuizFinishInterstitialAd(){

        if(mInterstitialAd != null) {

            mInterstitialAd.show(QuizScreen.this);

            mInterstitialAd.setFullScreenContentCallback(new FullScreenContentCallback() {
                @Override
                public void onAdDismissedFullScreenContent() {
                    super.onAdDismissedFullScreenContent();
                    goToQuizResultScreen();
                }
            });
        }
        else
        {
            goToQuizResultScreen();
        }


    }

    public void loadRewardedAd(MaterialCardView watchAdBtn, LottieAnimationView adProgressBar,String adId){

        AdRequest adRequest = new AdRequest.Builder().build();

        RewardedAd.load(QuizScreen.this, adId, adRequest, new RewardedAdLoadCallback() {
            @Override
            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                super.onAdFailedToLoad(loadAdError);
                Log.d(TAG,"Failed to load rewarded ad");
                watchAdBtn.setVisibility(View.VISIBLE);
                adProgressBar.setVisibility(View.GONE);
                QuizzeSnackBar.showSnackBar(QuizScreen.this,binding.getRoot(),getResources().getString(R.string.no_ads_available),getResources().getColor(R.color.error));
                mRewardedAd = null;
            }

            @Override
            public void onAdLoaded(@NonNull RewardedAd rewardedAd) {
                super.onAdLoaded(rewardedAd);
                mRewardedAd = rewardedAd;

                mRewardedAd.show(QuizScreen.this, new OnUserEarnedRewardListener() {
                    @Override
                    public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
                        if(noLivesBottomSheet.isShowing())
                        {
                            noLivesBottomSheet.cancel();
                        }
                        ++livesAvailable;
                        goToNextQuestion();
                    }
                });
            }
        });


    }

    public void showEndQuizInterstitialAd(){

        if(mInterstitialAd != null)
        {

            mInterstitialAd.show(QuizScreen.this);

            mInterstitialAd.setFullScreenContentCallback(new FullScreenContentCallback() {
                @Override
                public void onAdDismissedFullScreenContent() {
                    super.onAdDismissedFullScreenContent();
                    goToLoseActivity();
                }
            });

        }
        else
        {
            Log.d(TAG,"interstitial ad is null");
            goToLoseActivity();
        }

    }

    public void goToLoseActivity(){
        Intent intent = new Intent(QuizScreen.this,LoseActivity.class);
        intent.putExtra(Constants.adEnabled,adEnabled);
        intent.putExtra(Constants.nativeAdId,nativeAdId);
        intent.putExtra(Constants.interstitialAdId,interstitialAdId);
        intent.putExtra(Constants.rewardedAdId,rewardedAdId);
        startActivity(intent);
        finish();
    }

    public void goToQuizResultScreen(){
        quizBgMusic.stop();
        quizBgMusic.release();
        wrongAnswerMusic.release();
        correctAnswerMusic.release();
        Intent intent = new Intent(QuizScreen.this,QuizResultScreen.class);

        intent.putExtra(Constants.quizName,quizName);
        intent.putExtra(Constants.quizIcon,quizIcon);
        intent.putExtra(Constants.quizEntryFee,quizEntryFee);
        intent.putExtra(Constants.quizColorCode,quizColor);

        intent.putExtra(Constants.quizQuestionLimit,questionLimit);
        intent.putExtra(Constants.quizQuestionAttempted,questionAttempted);
        intent.putExtra(Constants.quizCorrectAnswers,correctAnswers);
        intent.putExtra(Constants.quizWrongAnswers,wrongAnswers);

        intent.putExtra(Constants.userScore,score);
        intent.putExtra(Constants.quizPrizePerQuestion,prizePerQuestion);

        intent.putExtra(Constants.adEnabled,adEnabled);
        intent.putExtra(Constants.nativeAdId,nativeAdId);
        intent.putExtra(Constants.interstitialAdId,interstitialAdId);
        intent.putExtra(Constants.rewardedAdId,rewardedAdId);

        startActivity(intent);
        finish();
    }

    public void showExitBottomSheet(){

        if(quizBgMusic.isPlaying())
        {
            quizBgMusic.pause();
            quizTimer.cancel();
        }

        exitBottomSheet = new BottomSheetDialog(QuizScreen.this);
        View view = LayoutInflater.from(QuizScreen.this).inflate(R.layout.exit_bottomsheet_layout,binding.getRoot().findViewById(R.id.exitLayout),false);
        exitBottomSheet.setContentView(view);
        exitBottomSheet.setCancelable(false);

        Button yesBtn = view.findViewById(R.id.yesBtn);
        Button noBtn = view.findViewById(R.id.noBtn);
        TextView exitTitle = view.findViewById(R.id.exitBottomSheetTitle);
        TextView exitSubText = view.findViewById(R.id.exitSubText);

        exitTitle.setText(String.format(QuizScreen.this.getResources().getString(R.string.exit_quiz_warning),quizName));
        exitSubText.setText(QuizScreen.this.getResources().getString(R.string.quiz_exit_subtext));

        yesBtn.setText(getResources().getString(R.string.exit_quiz));
        noBtn.setText(getResources().getString(R.string.continue_quiz));

        yesBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(quizTimer != null)
                {
                    quizTimer.cancel();
                }
                quizBgMusic.release();
                wrongAnswerMusic.release();
                correctAnswerMusic.release();
                showEndQuizInterstitialAd();
            }
        });

        noBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                exitBottomSheet.cancel();
                quizBgMusic.start();
                resumeQuiz(millisSecondLeft);
            }
        });

        if(!(QuizScreen.this).isFinishing())
        {
            exitBottomSheet.show();
        }

    }

    private void resumeQuiz(long timeLeftInMillis){
        quizTimer = new CountDownTimer(timeLeftInMillis,1000) {
            @Override
            public void onTick(long millisUntilFinished) {
                binding.quizTimerProgressBar.setMax(time);
                millisSecondLeft = millisUntilFinished;
                int timeLeft = (int) millisUntilFinished/1000;
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                    binding.quizTimerProgressBar.setProgress(timeLeft,true);
                }
                else
                {
                    binding.quizTimerProgressBar.setProgress(timeLeft);
                }

                if(timeLeft > time * 0.65)
                {
                    binding.quizTimerProgressBar.setIndicatorColor(getResources().getColor(R.color.success));
                }
                else if(timeLeft > time * 0.25)
                {
                    binding.quizTimerProgressBar.setIndicatorColor(getResources().getColor(R.color.warning));
                }
                else
                {
                    binding.quizTimerProgressBar.setIndicatorColor(getResources().getColor(R.color.error));
                }

            }

            @Override
            public void onFinish() {
                --livesAvailable;
                ++leavedQuestions;
                binding.userLives.setText(String.valueOf(livesAvailable));
                goToNextQuestion();
            }
        }.start();
    }

    public void showNoInternetBottomSheet(){

        noInternetBottomSheet = new BottomSheetDialog(QuizScreen.this);
        View view = LayoutInflater.from(QuizScreen.this).inflate(R.layout.error_occurred_bottom_sheet,findViewById(R.id.errorOccurredBottomSheetLayout),false);
        noInternetBottomSheet.setContentView(view);

        Button contactSupportBtn = noInternetBottomSheet.findViewById(R.id.bottomSheetSecondaryButton);
        Button tryAgainBtn = noInternetBottomSheet.findViewById(R.id.bottomSheetPrimaryButton);
        ImageView bottomSheetIllustration = noInternetBottomSheet.findViewById(R.id.bottomSheetIllustraton);
        TextView bottomSheetTitle = noInternetBottomSheet.findViewById(R.id.bottomSheetTitle);
        noInternetBottomSheet.setCancelable(false);
        TextView bottomSheetSubText = noInternetBottomSheet.findViewById(R.id.bottomSheetSubText);
        contactSupportBtn.setVisibility(View.GONE);

        tryAgainBtn.setText(getResources().getString(R.string.try_again));

        tryAgainBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(CheckInternetConnection.isInternetConnected(QuizScreen.this))
                {
                    noInternetBottomSheet.cancel();
                    getQuestions();
                }
                else
                {
                    QuizzeSnackBar.showSnackBar(QuizScreen.this,view,getResources().getString(R.string.no_internet),getResources().getColor(R.color.error));
                }
            }
        });

        bottomSheetTitle.setText(getResources().getString(R.string.no_internet));
        bottomSheetSubText.setText(getResources().getString(R.string.no_internet_sub_text));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable(QuizScreen.this,R.drawable.no_conection_illustration));

        if(!QuizScreen.this.isFinishing())
        {
            noInternetBottomSheet.show();
        }

    }

    public void showErrorOccurredBottomSheet(){

        errorOccurredBottomSheet = new BottomSheetDialog(QuizScreen.this);
        View view = LayoutInflater.from(QuizScreen.this).inflate(R.layout.error_occurred_bottom_sheet,findViewById(R.id.errorOccurredBottomSheetLayout),false);
        errorOccurredBottomSheet.setContentView(view);
        errorOccurredBottomSheet.setCancelable(false);
        Button contactSupportBtn = errorOccurredBottomSheet.findViewById(R.id.bottomSheetSecondaryButton);
        Button tryAgainBtn = errorOccurredBottomSheet.findViewById(R.id.bottomSheetPrimaryButton);
        ImageView bottomSheetIllustration = errorOccurredBottomSheet.findViewById(R.id.bottomSheetIllustraton);
        TextView bottomSheetTitle = errorOccurredBottomSheet.findViewById(R.id.bottomSheetTitle);
        TextView bottomSheetSubText = errorOccurredBottomSheet.findViewById(R.id.bottomSheetSubText);

        bottomSheetTitle.setText(getResources().getString(R.string.some_error_occurred));
        bottomSheetSubText.setText(getResources().getString(R.string.error_subtext));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable(QuizScreen.this,R.drawable.error_illustration));
        contactSupportBtn.setText(getResources().getString(R.string.contact_support));
        tryAgainBtn.setText(getResources().getString(R.string.try_again));

        contactSupportBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(QuizScreen.this, SupportScreen.class));
            }
        });

        tryAgainBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                errorOccurredBottomSheet.cancel();
                getQuestions();
            }
        });

        if(!QuizScreen.this.isFinishing())
        {
            errorOccurredBottomSheet.show();
        }
    }
}
